unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, Grids, DBGrids, DB, DBClient,
  UStrumien;

type
  TMainForm = class(TForm)
    ClientDataSet1: TClientDataSet;
    ClientDataSet1Nazwisko: TStringField;
    ClientDataSet1Imie: TStringField;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    sbKONIEC: TSpeedButton;
    sbMAKE_FILE: TSpeedButton;
    sbREADFROMFILE: TSpeedButton;
    DataSource1: TDataSource;
    procedure sbREADFROMFILEClick(Sender: TObject);
    procedure sbMAKE_FILEClick(Sender: TObject);
    procedure sbKONIECClick(Sender: TObject);

  private

  public
	 procedure Make_file();
    procedure Load_from_file();
  end;


var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.sbKONIECClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.sbMAKE_FILEClick(Sender: TObject);
begin
	sbMAKE_FILE.Visible := false;
   Make_file();
end;

procedure TMainForm.sbREADFROMFILEClick(Sender: TObject);
begin
	sbREADFROMFILE.Visible := false;
   Load_from_file();
end;

procedure TMainForm.Make_file();
var
   fName    : String;
   iSize    : LongInt;
   strumien : MStrumien;
   kom      : String;

begin
	fName    := '';
   iSize    := 0;
   strumien := NIl;

   fName := ExtractFilePath(Application.ExeName) + 'PROBA.TXT';
   if FileExists(fName) then
   begin
      DeleteFile(fName);
   end;

   try
      // utworzenie strumienia
      strumien := MStrumien.Create(fName, fmCreate);

      strumien.Set_nazwisko('Kowalski');
      strumien.Set_imie('Adam');
      strumien.Zapisz();

      strumien.Set_nazwisko('Kowalski');
      strumien.Set_imie('Krzysztof');
      strumien.Zapisz();

      strumien.Set_nazwisko('Kowalska');
      strumien.Set_imie('Anna');
      strumien.Zapisz();

      strumien.Set_nazwisko('Kowalska');
      strumien.Set_imie('Weronika');
      strumien.Zapisz();

      // pobierz rozmiar pliku:
      iSize := strumien.Size;
   finally
		FreeAndNil(strumien);
   end;

   if FileExists(fName) then
   begin
      kom := 'Plik: ' + fName + #10#13 + 'utworzony prawidowo' + #10#13 +
            'rozmiar pliku: ' + IntToStr(iSize);

      ShowMessage(kom);
   end
   else begin
      kom := 'Bd utworzenia pliku: ';
      kom := kom + #10#13 + fName;

      ShowMessage(kom);
   end;
end;

procedure TMainForm.Load_from_file();
var
   strumien  : MStrumien;
   nazwisko  : AnsiString;
   imie      : AnsiString;
   fName     : AnsiString;
   lp        : Integer;

begin
	strumien := Nil;
   nazwisko := '';
   imie     := '';
   fName    := '';

   fName := ExtractFilePath(Application.ExeName) + 'PROBA.TXT';

   if not FileExists(fName) then
   begin
   	ShowMessage('Brak pliku: ' + fName);
   	exit;
   end;

   try
      strumien := MStrumien.Create(fName, fmOpenRead);

      while not strumien.Eof() do
      begin
         nazwisko := '';
         imie     := '';

         strumien.Czytaj();

         nazwisko := strumien.Get_nazwisko();
         imie     := strumien.Get_imie();

         ClientDataSet1.Insert();

         ClientDataSet1.FieldByName('NAZWISKO').AsString := nazwisko;
         ClientDataSet1.FieldByName('IMIE').AsString     := imie;

         ClientDataSet1.Post();
      end;
   finally
 		FreeAndNil(strumien);
   end;
end;

end.

